<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/helper.php';
require_once __DIR__ . '/image_converter.php';

/**
 * Upload image ke WordPress sebagai media dan return ID media.
 */
function wp_upload_image($template, $imageUrl, $postTitle) {
    if (!$imageUrl) {
        return null;
    }

    $wpDomain = rtrim($template['wp_domain'], '/');
    $wpUser   = $template['wp_user'];
    $wpPass   = $template['wp_app_pass'];
    $imgSource = $template['img_source'] ?: 'OneFootball';

    // Download gambar pakai cURL dengan spoof referer
    $ch = curl_init($imageUrl);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTPHEADER => [
            'User-Agent: Mozilla/5.0',
            'Referer: https://onefootball.com/'
        ],
    ]);
    $imageData = curl_exec($ch);
    curl_close($ch);

    if (!$imageData) {
        throw new Exception('Gagal download gambar dari URL: ' . $imageUrl);
    }

    // Coba konversi ke JPEG bytes
    $jpegData = convert_to_jpeg_bytes($imageData);
    if ($jpegData) {
        $uploadData = $jpegData;
        $filename   = 'onefootball-' . time() . '.jpg';
        $mime       = 'image/jpeg';
    } else {
        // fallback: upload apa adanya, coba tebak mime dari ekstensi
        $uploadData = $imageData;
        $path = parse_url($imageUrl, PHP_URL_PATH);
        $ext  = strtolower(pathinfo($path, PATHINFO_EXTENSION));
        if (!$ext) $ext = 'jpg';
        $filename = 'onefootball-' . time() . '.' . $ext;
        $mime = 'image/jpeg';
        if ($ext === 'png') $mime = 'image/png';
        elseif ($ext === 'webp') $mime = 'image/webp';
    }

    $boundary = wp_generate_boundary();
    $eol = "\r\n";

    $body  = '--' . $boundary . $eol;
    $body .= 'Content-Disposition: form-data; name="file"; filename="' . $filename . '"' . $eol;
    $body .= 'Content-Type: ' . $mime . $eol . $eol;
    $body .= $uploadData . $eol;
    $body .= '--' . $boundary . $eol;
    $body .= 'Content-Disposition: form-data; name="title"' . $eol . $eol;
    $body .= $postTitle . $eol;
    $body .= '--' . $boundary . $eol;
    $body .= 'Content-Disposition: form-data; name="caption"' . $eol . $eol;
    $body .= 'Gambar istimewa by ' . $imgSource . $eol;
    $body .= '--' . $boundary . '--' . $eol;

    $headers = [
        'Authorization: Basic ' . base64_encode($wpUser . ':' . $wpPass),
        'Content-Type: multipart/form-data; boundary=' . $boundary,
    ];

    $url = $wpDomain . '/wp-json/wp/v2/media';

    $response = http_post($url, $body, $headers, false);
    $json = json_decode($response, true);

    if (isset($json['id'])) {
        return $json['id'];
    } else {
        throw new Exception('Gagal upload media. Response: ' . $response);
    }
}

function wp_generate_boundary() {
    return '--------------------------' . microtime(true);
}

/**
 * Posting artikel ke WordPress via REST API.
 */
function wp_post_article($template, $article) {
    $wpDomain  = rtrim($template['wp_domain'], '/');
    $wpUser    = $template['wp_user'];
    $wpPass    = $template['wp_app_pass'];
    $categoryId = (int)$template['wp_category'];

    $title = $article['title'];
    $content = $article['rewritten'] ?: $article['content'];

    $featured_media = null;
    if (!empty($article['img_url'])) {
        try {
            $featured_media = wp_upload_image($template, $article['img_url'], $title);
        } catch (Exception $e) {
            echo "Peringatan: gagal upload gambar untuk artikel ID {$article['id']}: " . $e->getMessage() . "\n";
        }
    }

    $payload = [
        'title'   => $title,
        'content' => $content,
        'status'  => 'publish',
    ];

    if ($categoryId > 0) {
        $payload['categories'] = [$categoryId];
    }
    if ($featured_media) {
        $payload['featured_media'] = $featured_media;
    }

    $headers = [
        'Authorization: Basic ' . base64_encode($wpUser . ':' . $wpPass),
        'Content-Type: application/json',
    ];

    $url = $wpDomain . '/wp-json/wp/v2/posts';

    $response = http_post($url, json_encode($payload), $headers);
    $json = json_decode($response, true);

    if (!isset($json['id'])) {
        throw new Exception('Gagal membuat post. Response: ' . $response);
    }

    return $json['id'];
}

/**
 * Proses batch artikel: ambil yang status = 'processed' dan kirim ke WordPress.
 */
function process_post_batch($templateId, $limit = 3) {
    global $pdo;

    $stmtTemplate = $pdo->prepare("SELECT * FROM templates WHERE id = ?");
    $stmtTemplate->execute([$templateId]);
    $template = $stmtTemplate->fetch();
    if (!$template) {
        throw new Exception('Template tidak ditemukan (ID: ' . $templateId . ').');
    }

    $stmt = $pdo->prepare("SELECT * FROM articles WHERE status = 'processed' ORDER BY id ASC LIMIT ?");
    $stmt->bindValue(1, (int)$limit, PDO::PARAM_INT);
    $stmt->execute();
    $articles = $stmt->fetchAll();

    foreach ($articles as $article) {
        try {
            echo "Posting artikel ID {$article['id']} ke WordPress...\n";
            $wpPostId = wp_post_article($template, $article);

            $upd = $pdo->prepare("UPDATE articles SET status = 'posted' WHERE id = ?");
            $upd->execute([$article['id']]);

            echo "OK: Artikel ID {$article['id']} berhasil dipost (WP ID: {$wpPostId}).\n";
        } catch (Exception $e) {
            echo "GAGAL posting ID {$article['id']}: " . $e->getMessage() . "\n";
        }
    }
}
