<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../core/helper.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = $pdo->prepare("SELECT * FROM templates WHERE id = ?");
$stmt->execute([$id]);
$template = $stmt->fetch();

if (!$template) {
    die('Template tidak ditemukan.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $upd = $pdo->prepare("UPDATE templates SET name = ?, api_key = ?, model = ?, temperature = ?, max_tokens = ?, top_p = ?, top_k = ?, wp_domain = ?, wp_user = ?, wp_app_pass = ?, wp_category = ?, img_source = ?, rewrite_prompt = ? WHERE id = ?");
    $upd->execute([
        $_POST['name'] ?? '',
        $_POST['api_key'] ?? '',
        $_POST['model'] ?? 'gemini-1.5-pro',
        $_POST['temperature'] ?? 0.6,
        $_POST['max_tokens'] ?? 2048,
        $_POST['top_p'] ?? 0.95,
        $_POST['top_k'] ?? 40,
        $_POST['wp_domain'] ?? '',
        $_POST['wp_user'] ?? '',
        $_POST['wp_app_pass'] ?? '',
        $_POST['wp_category'] ?? 0,
        $_POST['img_source'] ?? 'OneFootball',
        $_POST['rewrite_prompt'] ?? '',
        $id,
    ]);
    header('Location: templates.php?success=1');
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Edit Template</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-4">
    <h1 class="mb-4">Edit Template #<?= e($template['id']) ?></h1>
    <a href="templates.php" class="btn btn-secondary mb-3">← Kembali ke Daftar Template</a>

    <form method="post">
        <div class="mb-3">
            <label class="form-label">Nama Template</label>
            <input type="text" name="name" class="form-control" value="<?= e($template['name']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">API Key Google AI (Gemini)</label>
            <input type="text" name="api_key" class="form-control" value="<?= e($template['api_key']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Model Gemini</label>
            <input type="text" name="model" class="form-control" value="<?= e($template['model']) ?>">
        </div>

        <div class="row">
            <div class="col-4 mb-3">
                <label class="form-label">Temperature</label>
                <input type="number" step="0.1" name="temperature" class="form-control" value="<?= e($template['temperature']) ?>">
            </div>
            <div class="col-4 mb-3">
                <label class="form-label">Max Tokens</label>
                <input type="number" name="max_tokens" class="form-control" value="<?= e($template['max_tokens']) ?>">
            </div>
            <div class="col-4 mb-3">
                <label class="form-label">Top P</label>
                <input type="number" step="0.01" name="top_p" class="form-control" value="<?= e($template['top_p']) ?>">
            </div>
            <div class="col-4 mb-3">
                <label class="form-label">Top K</label>
                <input type="number" name="top_k" class="form-control" value="<?= e($template['top_k']) ?>">
            </div>
        </div>

        <hr>

        <div class="mb-3">
            <label class="form-label">Domain WordPress</label>
            <input type="text" name="wp_domain" class="form-control" value="<?= e($template['wp_domain']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Username Admin WP</label>
            <input type="text" name="wp_user" class="form-control" value="<?= e($template['wp_user']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Application Password WP</label>
            <input type="text" name="wp_app_pass" class="form-control" value="<?= e($template['wp_app_pass']) ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">ID Kategori WP</label>
            <input type="number" name="wp_category" class="form-control" value="<?= e($template['wp_category']) ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">Sumber Gambar (untuk caption)</label>
            <input type="text" name="img_source" class="form-control" value="<?= e($template['img_source']) ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">Rewrite Prompt</label>
            <textarea name="rewrite_prompt" class="form-control" rows="10"><?= e($template['rewrite_prompt']) ?></textarea>
        </div>

        <button class="btn btn-primary" type="submit">Simpan Perubahan</button>
    </form>
</div>
</body>
</html>
