<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../core/helper.php';

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['reset_all'])) {
        $pdo->exec("UPDATE articles SET status='draft', rewritten=NULL");
        $msg = 'Semua artikel di-reset ke draft.';
    } elseif (isset($_POST['truncate_all'])) {
        $pdo->exec("TRUNCATE TABLE articles");
        $msg = 'Tabel articles dikosongkan.';
    } elseif (isset($_POST['reset_one']) && !empty($_POST['article_id'])) {
        $id  = (int) $_POST['article_id'];
        $stm = $pdo->prepare("UPDATE articles SET status='draft', rewritten=NULL WHERE id=?");
        $stm->execute([$id]);
        $msg = 'Artikel ID ' . $id . ' di-reset ke draft.';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tools Artikel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container py-4">
    <h1 class="mb-4">Tools Artikel</h1>
    <a href="index.php" class="btn btn-secondary mb-3">← Kembali ke Dashboard</a>

    <?php if ($msg): ?>
        <div class="alert alert-info"><?= e($msg) ?></div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-4">
            <form method="post" class="card card-body mb-3">
                <h5>Reset Semua ke Draft</h5>
                <p class="small text-muted">Ubah semua artikel menjadi draft dan hapus hasil rewrite.</p>
                <button type="submit" name="reset_all" class="btn btn-warning" onclick="return confirm('Yakin reset semua artikel ke draft?')">Reset Semua</button>
            </form>
        </div>

        <div class="col-md-4">
            <form method="post" class="card card-body mb-3">
                <h5>Kosongkan Tabel Articles</h5>
                <p class="small text-muted">Hapus semua data artikel. Tidak bisa dibatalkan.</p>
                <button type="submit" name="truncate_all" class="btn btn-danger" onclick="return confirm('Yakin TRUNCATE semua artikel?')">Truncate</button>
            </form>
        </div>

        <div class="col-md-4">
            <form method="post" class="card card-body mb-3">
                <h5>Reset Satu Artikel</h5>
                <div class="mb-3">
                    <label class="form-label">ID Artikel</label>
                    <input type="number" name="article_id" class="form-control" required>
                </div>
                <button type="submit" name="reset_one" class="btn btn-primary">Reset Artikel</button>
            </form>
        </div>
    </div>
</div>
</body>
</html>
